const storageKey = 'a7f8dec4-828d-4ec4-b75e-d35a195388e8';
const google = {
    visualization: {
        Query: {
            setResponse(data) {
                const rows = data.table.rows.filter(row => row.c[2].v.toLowerCase() == 'yes');
                //
                if (rows.length <= 0) {
                    defaultImage();
                    return;
                }

                const key = storageKey + '|lastID';

                //
                let id = parseInt((localStorage.getItem(key) ?? -1)) + 1;
                if (id >= rows.length) id = 0;
                localStorage.setItem(key, id.toString());

                //
                const row = rows[id];
                document.querySelector('#name').innerText = row.c[0].v;
                document.querySelector('#medal').innerText = row.c[1].v;
                document.getElementById('content').classList.add('background');

                //
                const element = document.getElementById('text');
                const maxHeight = window.maxHeight ?? element.offsetHeight;
                let i = parseInt(window.getComputedStyle(element).fontSize);

                while (element.offsetHeight > maxHeight) {
                    element.style.fontSize = `${--i}px`;
                }
                element.style.opacity = '1';

                //
                if (
                    parseInt(document.getElementById('takes').getBoundingClientRect().top)
                    !== parseInt(document.getElementById('medal').getBoundingClientRect().top)
                ) {
                    document.getElementById('name').classList.add('block');
                }

            }
        }
    }
}

function defaultImage() {
    document.getElementById('content').classList.add('default');
}

let script = document.createElement('script')
script.setAttribute('src', 'https://docs.google.com/spreadsheets/d/1FeIA49ZLylJbPnAFpes93Y4uIvNkq3IWMd8nsI255yo/gviz/tq')
document.body.appendChild(script);
script.onerror = () => {
    defaultImage();
}

